function [N K h_m g_m] = channel( N, K, monte )

%% Initialization
h_m=zeros(N,1,2,K,monte); % uplink channels
g_m=zeros(N,1,2,K,monte); % downlink channels
d=zeros(2,K,1); % distances
PL=zeros(2,K,1); % pathloss
rho=1e-3; % reference pathloss for 1 meter
d0=1; % reference distance

%% Large-scale fading: pathloss
for k=1:K
    for i=1:2
          d(i,k)=1+rand(1);
          PL(i,k)=rho*(d(i,k)./d0)^-3;
    end
end

%% Small-scale fading: Rayleigh fading channel
for m =1:monte
    for k=1:K
        for i=1:2
            % Notice: from power to amplitude requires taking square root
            % Channels are complex
            h_m(:,:,i,k,m)=sqrt(PL(i,k))*sqrt(1/2)*(randn(N,1)+sqrt(-1)*randn(N,1)); 
            g_m(:,:,i,k,m)=sqrt(PL(i,k))*sqrt(1/2)*(randn(N,1)+sqrt(-1)*randn(N,1));
        end
    end
end

end

